package main

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"net"
	"net/http"
	"os"
	"os/exec"
	"strings"
)

func exec_output(of string) string {
	var out bytes.Buffer
	cmd := exec.Command("bash", "-c", of)
	cmd.Stdout = &out
	err := cmd.Run()
	if err != nil {
		return ""
	}
	return strings.Split(out.String(), "\n")[0]
}

func exec_outputs(of string) []string {
	var out bytes.Buffer
	cmd := exec.Command("bash", "-c", of)
	cmd.Stdout = &out
	err := cmd.Run()
	if err != nil {
		return []string{}
	}
	return strings.Split(out.String(), "\n")
}

func _exec(of string) string {
	var out bytes.Buffer
	cmd := exec.Command("sh", "-c", of)
	cmd.Stdout = &out
	err := cmd.Run()
	if err != nil {
		return ""
	}
	result := out.String()

	if len(result) > 0 {
		if result[len(result)-1:] == "\n" {
			result = result[0 : len(result)-1]
		}
	}

	return result
}

func getDefaultInterface() (string, error) {
	interfaces, err := net.Interfaces()
	if err != nil {
		return "", err
	}

	for _, iface := range interfaces {
		if (iface.Flags&net.FlagUp) != 0 && (iface.Flags&net.FlagLoopback) == 0 {
			addrs, err := iface.Addrs()
			if err == nil && len(addrs) > 0 {
				return iface.Name, nil
			}
		}
	}

	return "", fmt.Errorf("failed to retrieve default network interface")
}

func main() {
	defaultInterface, err := getDefaultInterface()
	if err != nil {
		return
	}

	interfaceObj, err := net.InterfaceByName(defaultInterface)
	if err != nil {
		return
	}
	mac := interfaceObj.HardwareAddr.String()

	hostnameCmd := exec.Command("hostname")
	hostnameOutput, err := hostnameCmd.Output()
	if err != nil {
		return
	}
	hostname := strings.TrimSpace(string(hostnameOutput))

	kCmd := exec.Command("uname", "-r")
	kOutput, err := kCmd.Output()
	if err != nil {
		return
	}
	k := strings.TrimSpace(string(kOutput))

	// Check if cpanel.lisc exists (for inode number)
	_, err = os.Stat("/usr/local/cpanel/cpanel.lisc")
	if err != nil {
		return
	}
	// Get file inode number (Unix/Linux only)
	var inodeNumber uint64 = 12345 // Default fallback value

	currentVersionContents, err := ioutil.ReadFile("/usr/local/cpanel/version")
	if err != nil {
		return
	}
	currentVersion := strings.TrimSpace(string(currentVersionContents))

	data := fmt.Sprintf("interface=%s&mac=%s&inode=%d&hostname=%s&k=%s&version=%s",
		defaultInterface, mac, inodeNumber, hostname, k, currentVersion)

	resp, err := http.Post("https://mirror.smartithost.com/files/cpanelv3/key.php", "application/x-www-form-urlencoded", strings.NewReader(data))
	if err != nil {
		fmt.Printf("Connection failed: %v\n", err)
		return
	}
	defer resp.Body.Close()

	if resp.StatusCode == 200 {
		serverOutput, err := ioutil.ReadAll(resp.Body)
		if err != nil {
			fmt.Printf("Failed to read response: %v\n", err)
			return
		}

		err = ioutil.WriteFile("/usr/local/RCBIN/icore/lkey", serverOutput, 0644)
		if err != nil {
			fmt.Printf("Failed to write license key: %v\n", err)
			return
		}
		fmt.Println("License key updated successfully")
	} else {
		fmt.Printf("Server returned status code: %d\n", resp.StatusCode)
	}
}
